//windows OS(10/7/8.1) . Scilab 6.0.1 (64-bit)
//toolbox null

// Transient response of RC Network using output equation method

clc
clear

R=500                                 // Resistance in a network
Ei=5                                  // Amplitude of input step signal
t=0:0.001:1;                 

//Case-1:
C1=10e-6                             // Capacitance value in RC circuit 10uF provided by user
Y1=R*C1
E1=Ei*(1-exp(-t/Y1))                // Formula for output voltage across capacitor
xlabel('Time')                     //Leveling x axis as time 
ylabel('Output voltage(V)')            //Leveling y axis as output voltage
title('Transient Response of RC circuit at Different Capacitance')    //Title of Graph
plot(t,E1)                          //Output Response with respect to time
plot(E1,"b")                      //Blue colour at C1

//Case-2:
C2=100e-6                                // Cacitance value in RC circuit 100uF provided by user
Y2=R*C2
E2=Ei*(1-exp(-t/Y2))                 // For output voltage across capacitor
xlabel('Time(s)')                         //Leveling x axis as time 
ylabel('Output voltage(V)')            //Leveling y axis as output voltage
plot(t,E2)
plot(E2,"g")                    //Green colour at C2

//Cse-3:
C3=200e-6                      // Cacitance value in RC circuit 200uF provided by user
Y3=R*C3
E3=Ei*(1-exp(-t/Y3))                  // For output voltage across capacitor
xlabel('Time(s)')                     //Leveling x axis as time 
ylabel('Output voltage(V)')           //Leveling y axis as output voltage
plot(t,E3)
plot(E3,"r")                               //Red colour at C3

legends(['E1';'E2';'E3'],[2,3,5],opt=1)    //Legend
xgrid(1)                                   //Grid 
